import { OpenAPI, AppointmentSearchService, AppointmentSearchResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getAppointmentSearch(appointment_searchId: string): Promise<AppointmentSearchResponse> {
  const response = await AppointmentSearchService.appointmentSearchGet({ id: appointment_searchId }) as unknown as ApiDataResponse<AppointmentSearchResponse>;

  const appointment_search = extractData(response);

  console.log(`AppointmentSearch: ${appointment_search.name || appointment_search.id}`);
  return appointment_search;
}
