import { OpenAPI, AppointmentSearchService, AppointmentSearchResponse, AppointmentSearchRequest } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateAppointmentSearch(appointment_searchId: string, tenantId: string, merchantId: string): Promise<AppointmentSearchResponse> {
  const today = new Date().toISOString().split('T')[0];
  const response = await AppointmentSearchService.appointmentSearchUpdate({
    id: appointment_searchId,
    requestBody: {
      tenant_id: tenantId,
      merchant_id: merchantId,
      date: today,
    }
  }) as unknown as ApiDataResponse<AppointmentSearchResponse>;

  const appointment_search = extractData(response);
  console.log(`Updated appointment_search: ${appointment_search.id}`);
  return appointment_search;
}
