import { OpenAPI, AppointmentService, AppointmentResponse, AppointmentRequest } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateAppointment(
  appointmentId: string,
  tenantId: string,
  merchantId: string,
  endCustomerId: string,
  serviceId: string,
  bookingId: string
): Promise<AppointmentResponse> {
  const startsAt = new Date(Date.now() + 48 * 60 * 60 * 1000); // Day after tomorrow
  const endsAt = new Date(startsAt.getTime() + 90 * 60 * 1000); // +1.5 hours

  const response = await AppointmentService.appointmentUpdate({
    id: appointmentId,
    requestBody: {
      status: AppointmentRequest.status.CONFIRMED,
      starts_at: startsAt.toISOString(),
      ends_at: endsAt.toISOString(),
      notes: 'Updated: Client confirmed attendance',
      tenant_id: tenantId,
      merchant_id: merchantId,
      end_customer_id: endCustomerId,
      service_id: serviceId,
      booking_id: bookingId
    }
  }) as unknown as ApiDataResponse<AppointmentResponse>;

  const appointment = extractData(response);
  console.log(`Updated appointment: ${appointment.id} (status: ${appointment.status})`);
  return appointment;
}
