import { OpenAPI, AuditLogService, AuditLogResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

// Configure the SDK client (can be overridden by K6 tests)
OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

/**
 * List audit logs with pagination
 */
export async function listAuditLogs(
  page: number = 1,
  pageSize: number = 50
): Promise<ApiListResponse<AuditLogResponse>> {
  const response = await AuditLogService.auditLogList({
    page,
    pageSize,
    orderBy: 'inserted_at'
  }) as unknown as ApiListResponse<AuditLogResponse>;

  console.log(`Listed ${response.data.length} audit logs (page ${page} of ${response.meta.total_pages})`);
  return response;
}
