import { OpenAPI, AuditLogService, AuditLogResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

// Configure the SDK client (can be overridden by K6 tests)
OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

/**
 * Get a single audit log by ID
 */
export async function getAuditLog(auditLogId: string): Promise<AuditLogResponse> {
  const response = await AuditLogService.auditLogGet({
    id: auditLogId
  }) as unknown as ApiDataResponse<AuditLogResponse>;

  const auditLog = extractData(response);
  console.log(`Retrieved audit log: ${auditLog.id} - ${auditLog.action}`);
  return auditLog;
}
