import { OpenAPI, AvailabilityService, AvailabilityResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listAvailabilities(
  page = 1,
  pageSize = 20
): Promise<ApiListResponse<AvailabilityResponse>> {
  const response = await AvailabilityService.availabilityList({
    page,
    pageSize,
    orderBy: 'start_at'
  }) as unknown as ApiListResponse<AvailabilityResponse>;

  console.log(`Retrieved ${response.data?.length || 0} availabilities (page ${page})`);
  return response;
}
