import { OpenAPI, AvailabilityService, AvailabilityResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getAvailability(id: string): Promise<AvailabilityResponse> {
  const response = await AvailabilityService.availabilityGet({ id }) as unknown as ApiDataResponse<AvailabilityResponse>;
  const availability = extractData(response);
  console.log(`Retrieved availability: ${availability.id}`);
  return availability;
}
