import { OpenAPI, AvailabilityService, AvailabilityResponse, AvailabilityRequest } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateAvailability(
  id: string,
  tenantId: string,
  merchantId: string,
  serviceId: string,
  providerId?: string,
  locationId?: string
): Promise<AvailabilityResponse> {
  const startAt = new Date(Date.now() + 48 * 60 * 60 * 1000); // Day after tomorrow

  const response = await AvailabilityService.availabilityUpdate({
    id,
    requestBody: {
      status: AvailabilityRequest.status.BOOKED,
      start_at: startAt.toISOString(),
      duration_minutes: 90,
      tenant_id: tenantId,
      merchant_id: merchantId,
      service_id: serviceId,
      provider_id: providerId,
      location_id: locationId
    }
  }) as unknown as ApiDataResponse<AvailabilityResponse>;

  const availability = extractData(response);
  console.log(`Updated availability: ${availability.id} (status: ${availability.status})`);
  return availability;
}
