import { OpenAPI, BookingEnquiryService, BookingEnquiryResponse, BookingEnquiryRequest } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createBookingEnquiry(
  tenantId: string,
  merchantId: string,
  endCustomerId: string,
  serviceIds: string[]
): Promise<BookingEnquiryResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const today = new Date();
  const startDate = today.toISOString().split('T')[0];
  const endDate = new Date(today.getTime() + 7 * 24 * 60 * 60 * 1000).toISOString().split('T')[0];

  const response = await BookingEnquiryService.bookingEnquiryCreate({
    requestBody: {
      status: BookingEnquiryRequest.status.SEARCHED,
      tenant_id: tenantId,
      merchant_id: merchantId,
      end_customer_id: endCustomerId,
      service_ids: serviceIds,
      start_date: startDate,
      end_date: endDate,
      first_name: `Test ${uniqueId}`,
      last_name: 'Customer',
      email: `test-${uniqueId}@example.com`,
      phone: '+15551234567'
    } as any
  }) as unknown as ApiDataResponse<BookingEnquiryResponse>;

  const bookingEnquiry = extractData(response);
  console.log(`Created booking enquiry: ${bookingEnquiry.id} (status: ${bookingEnquiry.status})`);
  return bookingEnquiry;
}
