import { OpenAPI, BookingEnquiryService, BookingEnquiryResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getBookingEnquiry(id: string): Promise<BookingEnquiryResponse> {
  const response = await BookingEnquiryService.bookingEnquiryGet({
    id
  }) as unknown as ApiDataResponse<BookingEnquiryResponse>;

  const bookingEnquiry = extractData(response);
  console.log(`Retrieved booking enquiry: ${bookingEnquiry.id} (status: ${bookingEnquiry.status})`);
  return bookingEnquiry;
}
