import { OpenAPI, BookingPolicyService, BookingPolicyResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createBookingPolicy(tenantId: string, merchantId: string): Promise<BookingPolicyResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await BookingPolicyService.bookingPolicyCreate({
    requestBody: {
      name: `Test BookingPolicy ${uniqueId}`,
      policy_type: 'book_appointment' as any,
      effect: 'allow' as any,
      priority: 'normal' as any,
      min_age: 0,
      customer_statuses: ['new', 'established'],
      tenant_id: tenantId,
      merchant_id: merchantId,
    }
  }) as unknown as ApiDataResponse<BookingPolicyResponse>;

  const booking_policy = extractData(response);
  console.log(`Created booking_policy: ${booking_policy.name || booking_policy.id} (${booking_policy.id})`);
  return booking_policy;
}
