import { OpenAPI, BookingService, BookingResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listBookings(
  page = 1,
  pageSize = 20
): Promise<ApiListResponse<BookingResponse>> {
  const response = await BookingService.bookingList({
    page,
    pageSize,
    orderBy: 'inserted_at'
  }) as unknown as ApiListResponse<BookingResponse>;

  console.log(`Retrieved ${response.data?.length || 0} bookings (page ${page})`);
  return response;
}
