import { OpenAPI, EndCustomerService, EndCustomerResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listEndCustomers(): Promise<ApiListResponse<EndCustomerResponse>> {
  const response = await EndCustomerService.endCustomerList({
    page: 1,
    pageSize: 10,
    orderBy: 'inserted_at',
  }) as unknown as ApiListResponse<EndCustomerResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} customers (total: ${meta.total_count})`);
  data.forEach((customer) => {
    console.log(`- ${customer.first_name} ${customer.last_name} (${customer.email})`);
  });
  return response;
}
