import { OpenAPI, FormResponseService, FormResponseResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createFormResponse(
  tenantId: string,
  merchantId: string,
  endCustomerId: string
): Promise<FormResponseResponse> {
  const submissionDate = new Date();

  const response = await FormResponseService.formResponseCreate({
    requestBody: {
      name: 'Patient Intake Form',
      form_type: 'intake',
      submission_date: submissionDate.toISOString(),
      tenant_id: tenantId,
      merchant_id: merchantId,
      end_customer_id: endCustomerId
    }
  }) as unknown as ApiDataResponse<FormResponseResponse>;

  const formResponse = extractData(response);
  console.log(`Created form response: ${formResponse.name} (${formResponse.id})`);
  return formResponse;
}
