import { OpenAPI, FormResponseService, FormResponseResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getFormResponse(id: string): Promise<FormResponseResponse> {
  const response = await FormResponseService.formResponseGet({ id }) as unknown as ApiDataResponse<FormResponseResponse>;
  const formResponse = extractData(response);
  console.log(`Retrieved form response: ${formResponse.name} (${formResponse.id})`);
  return formResponse;
}
