import { OpenAPI, InvoiceService, InvoiceResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getInvoice(invoiceId: string): Promise<InvoiceResponse> {
  const response = await InvoiceService.invoiceGet({ id: invoiceId }) as unknown as ApiDataResponse<InvoiceResponse>;

  const invoice = extractData(response);

  console.log(`Invoice: ${invoice.number || invoice.id}`);
  return invoice;
}
