import { OpenAPI, InvoiceService, InvoiceResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateInvoice(invoiceId: string, tenantId: string, merchantId: string): Promise<InvoiceResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await InvoiceService.invoiceUpdate({
    id: invoiceId,
    requestBody: {
      amount_due: { amount: 15000, currency: 'USD' },
      amount_paid: { amount: 0, currency: 'USD' },
      status: 'draft',
      tenant_id: tenantId,
      merchant_id: merchantId,
      description: `Updated Invoice ${uniqueId}`,
    }
  }) as unknown as ApiDataResponse<InvoiceResponse>;

  const invoice = extractData(response);
  console.log(`Updated invoice: ${invoice.number || invoice.id}`);
  return invoice;
}
