import { OpenAPI, LocationService, LocationResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateLocation(locationId: string, tenantId: string, merchantId: string): Promise<LocationResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await LocationService.locationUpdate({
    id: locationId,
    requestBody: {
      name: `Updated Location ${uniqueId}`,
      address_line1: `456 Updated Ave ${uniqueId}`,
      city: 'San Francisco',
      state: 'CA',
      postal_code: '94103',
      country: 'US',
      tenant_id: tenantId,
      merchant_id: merchantId
    }
  }) as unknown as ApiDataResponse<LocationResponse>;

  const location = extractData(response);
  console.log(`Updated location: ${location.name}`);
  return location;
}
