import { OpenAPI, MerchantOrgService } from '@scp/sdk';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

/**
 * Delete a merchant organization
 */
export async function deleteMerchantOrg(merchantOrgId: string): Promise<void> {
  await MerchantOrgService.merchantOrgDelete({ id: merchantOrgId });
  console.log(`Deleted merchant org: ${merchantOrgId}`);
}
