import { OpenAPI, MerchantOrgService, MerchantOrgResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

/**
 * Get a single merchant organization by ID
 */
export async function getMerchantOrg(merchantOrgId: string): Promise<MerchantOrgResponse> {
  const response = await MerchantOrgService.merchantOrgGet({ id: merchantOrgId }) as unknown as ApiDataResponse<MerchantOrgResponse>;

  // API returns {data: {...}}, extract the actual merchant org
  const merchantOrg = extractData(response);

  console.log(`Merchant Org: ${merchantOrg.name}`);
  console.log(`Status: ${merchantOrg.status}`);
  console.log(`Email: ${merchantOrg.email || '(none)'}`);
  return merchantOrg;
}
