import { OpenAPI, MerchantOrgService, MerchantOrgResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

/**
 * Update a merchant organization
 */
export async function updateMerchantOrg(merchantOrgId: string, tenantId: string): Promise<MerchantOrgResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await MerchantOrgService.merchantOrgUpdate({
    id: merchantOrgId,
    requestBody: {
      name: `Updated Corp ${uniqueId}`,
      email: `updated-${uniqueId}@example.com`,
      tenant_id: tenantId
    }
  }) as unknown as ApiDataResponse<MerchantOrgResponse>;

  // API returns {data: {...}}, extract the actual merchant org
  const merchantOrg = extractData(response);
  console.log(`Updated merchant org: ${merchantOrg.name}`);
  return merchantOrg;
}
