import { OpenAPI, MerchantService, MerchantResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

/**
 * Create a new merchant
 */
export async function createMerchant(tenantId: string, merchantOrgId: string): Promise<MerchantResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await MerchantService.merchantCreate({
    requestBody: {
      name: `Salon Location ${uniqueId}`,
      public_name: `Premium Salon ${uniqueId}`,
      tenant_id: tenantId,
      merchant_org_id: merchantOrgId
    }
  }) as unknown as ApiDataResponse<MerchantResponse>;

  const merchant = extractData(response);
  console.log(`Created merchant: ${merchant.name} (${merchant.id})`);
  return merchant;
}
