import { OpenAPI, MerchantService, MerchantResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

/**
 * List merchants with pagination
 */
export async function listMerchants(): Promise<ApiListResponse<MerchantResponse>> {
  const response = await MerchantService.merchantList({
    page: 1,
    pageSize: 10,
    orderBy: 'name',
  }) as unknown as ApiListResponse<MerchantResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} merchants (total: ${meta.total_count})`);
  data.forEach((merchant) => {
    console.log(`- ${merchant.name} (${merchant.public_name})`);
  });
  return response;
}
