import { OpenAPI, MessageService, MessageResponse, MessageRequest } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createMessage(
  tenantId: string,
  merchantId: string,
  endCustomerId: string,
  pluginId: string
): Promise<MessageResponse> {
  const uniqueId = uuidv4().substring(0, 8);

  const response = await MessageService.messageCreate({
    requestBody: {
      body: `Test message ${uniqueId}`,
      to: '+15551234567',
      from: '+15559876543',
      direction: MessageRequest.direction.OUTBOUND,
      channel: MessageRequest.channel.SMS,
      status: 'created',
      tenant_id: tenantId,
      merchant_id: merchantId,
      end_customer_id: endCustomerId,
      plugin_id: pluginId,
      idempotency_key: `msg_${uuidv4()}`,
      message_number: 0
    }
  }) as unknown as ApiDataResponse<MessageResponse>;

  const message = extractData(response);
  console.log(`Created message: ${message.id} (channel: ${message.channel})`);
  return message;
}
