import { OpenAPI, MessageService, MessageResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listMessages(
  page: number = 1,
  pageSize: number = 10
): Promise<ApiListResponse<MessageResponse>> {
  const response = await MessageService.messageList({
    page,
    pageSize
  }) as unknown as ApiListResponse<MessageResponse>;

  console.log(`Listed ${response.data.length} messages (page ${page})`);
  return response;
}
