import { OpenAPI, MessageService, MessageResponse, MessageRequest } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateMessage(
  id: string,
  tenantId: string,
  merchantId: string,
  endCustomerId: string,
  pluginId: string
): Promise<MessageResponse> {
  const response = await MessageService.messageUpdate({
    id,
    requestBody: {
      body: `Updated message body ${Date.now()}`,
      to: '+1987654321',
      direction: MessageRequest.direction.OUTBOUND,
      channel: MessageRequest.channel.SMS,
      status: 'sent',
      end_customer_id: endCustomerId,
      merchant_id: merchantId,
      plugin_id: pluginId,
      tenant_id: tenantId,
      idempotency_key: `upd-${Date.now()}`,
      message_number: 0
    }
  }) as unknown as ApiDataResponse<MessageResponse>;

  const message = extractData(response);
  console.log(`Updated message: ${message.id}`);
  return message;
}
