import { OpenAPI, NotificationPolicyService, NotificationPolicyResponse, NotificationPolicyRequest } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createNotificationPolicy(tenantId: string, merchantId: string): Promise<NotificationPolicyResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await NotificationPolicyService.notificationPolicyCreate({
    requestBody: {
      name: `Test NotificationPolicy ${uniqueId}`,
      notification_type: 'appointment_confirmation' as any,
      is_active: true,
      tenant_id: tenantId,
      merchant_id: merchantId,
    }
  }) as unknown as ApiDataResponse<NotificationPolicyResponse>;

  const notification_policy = extractData(response);
  console.log(`Created notification_policy: ${notification_policy.name || notification_policy.id} (${notification_policy.id})`);
  return notification_policy;
}
