import { OpenAPI, NotificationPolicyService, NotificationPolicyResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getNotificationPolicy(notification_policyId: string): Promise<NotificationPolicyResponse> {
  const response = await NotificationPolicyService.notificationPolicyGet({ id: notification_policyId }) as unknown as ApiDataResponse<NotificationPolicyResponse>;

  const notification_policy = extractData(response);

  console.log(`NotificationPolicy: ${notification_policy.name || notification_policy.id}`);
  return notification_policy;
}
