import { OpenAPI, PaymentAccountService, PaymentAccountResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getPaymentAccount(paymentAccountId: string): Promise<PaymentAccountResponse> {
  const response = await PaymentAccountService.paymentAccountGet({ id: paymentAccountId }) as unknown as ApiDataResponse<PaymentAccountResponse>;

  const payment_account = extractData(response);

  console.log(`Payment account: ${payment_account.brand || payment_account.type} *${payment_account.last_4 || '****'}`);
  return payment_account;
}
