import { OpenAPI, PaymentAccountService, PaymentAccountResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updatePaymentAccount(
  paymentAccountId: string,
  tenantId: string,
  merchantId: string,
  endCustomerId: string,
  pluginId: string
): Promise<PaymentAccountResponse> {
  const response = await PaymentAccountService.paymentAccountUpdate({
    id: paymentAccountId,
    requestBody: {
      type: 'card' as any,
      status: 'active' as any,
      external_id: `pm_updated_${Date.now()}`,
      last_4: '5555',
      brand: 'mastercard',
      exp_month: 6,
      exp_year: 2027,
      is_default: true,
      tenant_id: tenantId,
      merchant_id: merchantId,
      end_customer_id: endCustomerId,
      plugin_id: pluginId,
    }
  }) as unknown as ApiDataResponse<PaymentAccountResponse>;

  const payment_account = extractData(response);
  console.log(`Updated payment account: ${payment_account.brand} *${payment_account.last_4}`);
  return payment_account;
}
