import { OpenAPI, ProviderService, ProviderResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listProviders(): Promise<ApiListResponse<ProviderResponse>> {
  const response = await ProviderService.providerList({
    page: 1,
    pageSize: 10,
    orderBy: 'name',
  }) as unknown as ApiListResponse<ProviderResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} providers (total: ${meta.total_count})`);
  data.forEach((provider) => {
    console.log(`- ${provider.name} (${provider.headline})`);
  });
  return response;
}
