import { OpenAPI, RoleService, RoleResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateRole(roleId: string, tenantId: string): Promise<RoleResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await RoleService.roleUpdate({
    id: roleId,
    requestBody: {
      name: `updated_role_${uniqueId}`,
      description: 'Updated role',
      tenant_id: tenantId,
      home_path: '/dashboard'
    }
  }) as unknown as ApiDataResponse<RoleResponse>;

  // API returns {data: {...}}, extract the actual role
  const role = extractData(response);
  console.log(`Updated role: ${role.name}`);
  return role;
}
