import { OpenAPI, ServiceService, ServiceResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getService(serviceId: string): Promise<ServiceResponse> {
  const response = await ServiceService.serviceGet({ id: serviceId }) as unknown as ApiDataResponse<ServiceResponse>;

  const service = extractData(response);

  console.log(`Service: ${service.name}`);
  console.log(`Duration: ${service.duration} minutes`);
  console.log(`Price: ${service.standard_rate_str}`);
  return service;
}
