import { OpenAPI, ServiceService, ServiceResponse, ServiceRequest } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateService(serviceId: string, tenantId: string, merchantId: string): Promise<ServiceResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await ServiceService.serviceUpdate({
    id: serviceId,
    requestBody: {
      name: `Updated Service ${uniqueId}`,
      description: 'Updated professional service',
      type: ServiceRequest.type.FITNESS_TRAINING,
      duration: 90,
      is_legacy: false,
      standard_rate_str: 'USD 150.00',
      no_show_fees_str: 'USD 30.00',
      tenant_id: tenantId,
      merchant_id: merchantId
    }
  }) as unknown as ApiDataResponse<ServiceResponse>;

  const service = extractData(response);
  console.log(`Updated service: ${service.name}`);
  return service;
}
