import { OpenAPI, SubscriptionService, SubscriptionResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createSubscription(tenantId: string, merchantId: string): Promise<SubscriptionResponse> {
  const now = new Date();
  const periodEnd = new Date(now.getTime() + 30 * 24 * 60 * 60 * 1000); // 30 days from now

  const response = await SubscriptionService.subscriptionCreate({
    requestBody: {
      type: 'discovery_agent' as any,
      status: 'active' as any,
      billing_period: 'monthly' as any,
      price: 9900,
      currency: 'usd',
      quantity: 1,
      current_period_start: now.toISOString(),
      current_period_end: periodEnd.toISOString(),
      tenant_id: tenantId,
      merchant_id: merchantId,
    }
  }) as unknown as ApiDataResponse<SubscriptionResponse>;

  const subscription = extractData(response);
  console.log(`Created subscription: ${subscription.type} - $${(subscription.price || 0) / 100}/mo (${subscription.id})`);
  return subscription;
}
