import { OpenAPI, TenantService, TenantResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

// Configure the SDK client (can be overridden by K6 tests)
OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

/**
 * Create a new tenant
 */
export async function createTenant(): Promise<TenantResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await TenantService.tenantCreate({
    requestBody: {
      name: `Acme Salon ${uniqueId}`,
      type: TenantResponse.type.ENTERPRISE,
      domain_name: `acme-${uniqueId}.example.com`
    }
  }) as unknown as ApiDataResponse<TenantResponse>;

  // API returns {data: {...}}, extract the actual tenant
  const tenant = extractData(response);
  console.log(`Created tenant: ${tenant.name} (${tenant.id})`);
  return tenant;
}
