import { OpenAPI, TenantService, TenantResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

/**
 * Update a tenant
 */
export async function updateTenant(tenantId: string): Promise<TenantResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await TenantService.tenantUpdate({
    id: tenantId,
    requestBody: {
      name: `Updated Salon ${uniqueId}`,
      type: TenantResponse.type.ENTERPRISE,
      domain_name: `updated-${uniqueId}.example.com`
    }
  }) as unknown as ApiDataResponse<TenantResponse>;

  // API returns {data: {...}}, extract the actual tenant
  const tenant = extractData(response);
  console.log(`Updated tenant: ${tenant.name}`);
  return tenant;
}
