import { OpenAPI, TransactionJournalService, TransactionJournalResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listTransactionJournals(
  page: number = 1,
  pageSize: number = 10
): Promise<ApiListResponse<TransactionJournalResponse>> {
  const response = await TransactionJournalService.transactionJournalList({
    page,
    pageSize
  }) as unknown as ApiListResponse<TransactionJournalResponse>;

  console.log(`Listed ${response.data.length} transaction journals (page ${page})`);
  return response;
}
