import { OpenAPI, TransactionService, TransactionResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateTransaction(
  transactionId: string,
  tenantId: string,
  merchantId: string,
  endCustomerId: string,
  pluginId: string
): Promise<TransactionResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await TransactionService.transactionUpdate({
    id: transactionId,
    requestBody: {
      amount: { amount: 7500, currency: 'usd' },
      transaction_type: 'charge' as any,
      status: 'succeeded' as any,
      description: `Updated Transaction ${uniqueId}`,
      end_customer_id: endCustomerId,
      plugin_id: pluginId,
      tenant_id: tenantId,
      merchant_id: merchantId,
    }
  }) as unknown as ApiDataResponse<TransactionResponse>;

  const transaction = extractData(response);
  console.log(`Updated transaction: ${transaction.transaction_type} - $${(transaction.amount?.amount || 0) / 100}`);
  return transaction;
}
