import { OpenAPI, WebsiteService, WebsiteResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createWebsite(
  tenantId: string,
  merchantId: string,
  merchantOrgId?: string
): Promise<WebsiteResponse> {
  const uniqueId = uuidv4().substring(0, 8);

  const response = await WebsiteService.websiteCreate({
    requestBody: {
      domain_name: `${uniqueId}.example.com`,
      title: `Test Website ${uniqueId}`,
      description: `A test website for ${uniqueId}`,
      tenant_id: tenantId,
      merchant_id: merchantId,
      merchant_org_id: merchantOrgId,
      favicon: { url: 'https://example.com/favicon.ico' },
      logo: { url: 'https://example.com/logo.png' },
      login_allowed: true,
      translation_allowed: false,
      google_tag_id: 'G-TESTID123'
    }
  }) as unknown as ApiDataResponse<WebsiteResponse>;

  const website = extractData(response);
  console.log(`Created website: ${website.domain_name} (${website.id})`);
  return website;
}
