import { OpenAPI, WebsiteService, WebsiteResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listWebsites(
  page: number = 1,
  pageSize: number = 10
): Promise<ApiListResponse<WebsiteResponse>> {
  const response = await WebsiteService.websiteList({
    page,
    pageSize
  }) as unknown as ApiListResponse<WebsiteResponse>;

  console.log(`Listed ${response.data.length} websites (page ${page})`);
  return response;
}
