import { OpenAPI, WebsiteService, WebsiteResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getWebsite(id: string): Promise<WebsiteResponse> {
  const response = await WebsiteService.websiteGet({
    id
  }) as unknown as ApiDataResponse<WebsiteResponse>;

  const website = extractData(response);
  console.log(`Retrieved website: ${website.domain_name}`);
  return website;
}
