import { defineConfig } from 'vitest/config';
import path from 'path';

export default defineConfig({
  resolve: {
    alias: {
      '@scp/sdk': path.resolve(__dirname, '../generated'),
      '@scp/client-samples': path.resolve(__dirname, '../client_samples/typescript'),
    },
  },
  test: {
    globals: true,
    environment: 'node',
    setupFiles: ['./vitest.setup.ts'],
    testTimeout: 30000, // 30s for API calls
    hookTimeout: 30000,
    fileParallelism: false, // Run test files sequentially to avoid database conflicts
    // Set default environment variables for tests
    // BASE_URL is NOT set here so Optic can override it for API coverage
    env: {
      ADMIN_EMAIL: 'admin@alvera-scp-dev.local',
      ADMIN_PASSWORD: 'DevPassword123!',
      TENANT_NAME: 'alvera-scp-dev',
    },
    coverage: {
      provider: 'v8',
      reporter: ['text', 'json', 'html'],
      reportsDirectory: './coverage',
    },
  },
});
