import { OpenAPI, AuthenticationService } from '@scp/sdk';
import { resetDatabase } from './helpers/sandbox';
import { beforeAll } from 'vitest';

// Configure SDK with environment variables
// Only override BASE if explicitly set via env var
// Otherwise use SDK's built-in BASE (set during generation from openapi.yaml servers)
if (process.env.BASE_URL && process.env.BASE_URL.startsWith('http')) {
  OpenAPI.BASE = process.env.BASE_URL;
}
OpenAPI.TOKEN = ''; // Will be set during test authentication

console.log(`🧪 Vitest Integration Tests`);
console.log(`   Base URL: ${OpenAPI.BASE}`);

// Global setup: Authenticate and reset database before all tests
beforeAll(async () => {
  // Authenticate to get admin token
  const authResponse = await AuthenticationService.scpApiSessionControllerCreate({
    requestBody: {
      email: process.env.ADMIN_EMAIL || 'admin@alvera-scp-dev.local',
      password: process.env.ADMIN_PASSWORD || 'DevPassword123!',
      tenant_name: process.env.TENANT_NAME || 'alvera-scp-dev',
    },
  }) as any;

  OpenAPI.TOKEN = authResponse.token;

  // Reset database to clean state
  await resetDatabase();

  console.log(`✅ Setup complete: Database reset, token acquired`);
});
